export interface Product {
  id: string
  name: string
  brand: string | Brand
  category: string
  subCategory?: string
  price: number
  image: string
  rating: number
  likes: number
  dislikes: number
  kaliteliHammadde?: boolean
  yerliMarka?: boolean
  evaluation?: {
    temiz_icerik?: number
    formul_kalitesi?: number
    uretim_tesisi?: number
    kullanici_yorumlari?: number
    uretim_sertifika?: number
    ai_guven_skoru?: number
    dradvice?: boolean
    certFactors?: {
      gmp?: boolean
      haccp?: boolean
      iso9001?: boolean
      iso22000?: boolean
    }
  }
  cleanFactors?: {
    form: {
      tablet: boolean
      kapsul: boolean
      toz: boolean
      sase: boolean
      gummy: boolean
      sivi: boolean
      granül?: boolean
      pastil?: boolean
    }
    additives: {
      renklendirici: boolean
      aroma: boolean
      tatlandirici: boolean
    }
  }
  buyLink?: string
  icerik?: string[]
  icerik_bilgisi?: Record<string, string>
  usage?: string
  createdAt?: Date
  influencerCommission?: { platform: string; rate: number }[]
  onayNo?: string
  tags?: string[]
  trendyolUrl?: string // New field for Trendyol URL
}

export interface Brand {
  id: string
  name: string
  logoUrl?: string
  countryCode?: string
  stars?: number
  likes?: number
  dislikes?: number
  bio?: Array<{
    content: string
    reference?: string
  }>
  createdAt?: Date
  influencerCommission?: { platform: string; rate: number }[]
  certificates?: {
    gmp?: boolean
    haccp?: boolean
    iso9001?: boolean
    iso22000?: boolean
    [key: string]: boolean | undefined
  }
}

export interface Review {
  id: string
  username: string
  date: string
  rating: number
  review: string
  source?: string
}

// Beğeni sistemi için yeni tipler
export interface VoteData {
  id: string
  type: 'product' | 'brand'
  vote: 'like' | 'dislike' | null
  ip: string
  userAgent: string
  timestamp: number
}

export interface VoteSummary {
  likes: number
  dislikes: number
  totalVotes: number
  likePercentage: number
}

export interface SubCategory {
  id: string
  name: string
}

export interface Category {
  id: string
  name: string
  subCategories: SubCategory[]
  createdAt: Date
}

export interface Facility {
  id: string
  name: string
  logoUrl?: string
  bio?: Array<{
    content: string
    reference?: string
  }>
  certificates?: {
    gmp?: boolean
    haccp?: boolean
    iso9001?: boolean
    iso22000?: boolean
    [key: string]: boolean | undefined
  }
  brandsProduced?: string[]
  score: number // 100 üzerinden
  createdAt?: Date
}

export interface ProductRequest {
  id: string;
  productName: string;
  category: string;
  brand: string;
  status: 'pending' | 'approved' | 'rejected';
  createdAt: Date;
  notes?: string;
}

export interface HomePageSection {
  id: string;
  type: "featured_product" | "product_carousel" | "all_products" | "custom_carousel" | "doctor_approved_carousel" | "top_quality_product" | "custom_widget" | "info_card";
  title?: string;
  description?: string; // Added description
  productId?: string; // Used for featured_product
  category?: string;
  filter?: "most_liked" | "newest" | "dradvice_products" | "custom_products";
  order: number;
  bgColor?: string;
  productIds?: string[]; // Used for custom_products filter
  customCarouselId?: string; // Used for custom_carousel and doctor_approved_carousel
  featuredProductId?: string; // Used for top_quality_product
  sectionId?: string; // Link to a CustomWidgetTemplate
  x: number;
  y: number;
  w: number;
  h: number;
}

export interface CustomWidgetTemplate {
  id: string;
  name: string; // Name of the template, e.g., "Doktor Onaylı Karosel Şablonu"
  type: "product_carousel" | "single_product" | "info_card"; // Type of widget this template represents
  productIds?: string[]; // For product_carousel type
  productId?: string; // For single_product type
  title?: string; // Customizable title for the widget
  description?: string; // Customizable description
  bgColor?: string; // Customizable background color
  widgetTags?: string[]; // New: Customizable tags for the widget
  w?: number; // Width of the widget (in grid units)
  h?: number; // Height of the widget (in grid units)
  infoContent?: string; // For info_card type
  sourceLink?: string; // For info_card type
  infoImageUrl?: string; // For info_card type: image url
  showAdsense?: boolean; // Yeni: Adsense kutucuğu
}
