"use client"

import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import JsonExporter from "@/components/admin/JsonExporter";
import JsonImporterTab from "@/components/admin/JsonImporterTab";
import type { Product, Brand, Facility } from "@/types";

interface JsonTabProps {
  products: Product[];
  brands: Brand[];
  facilities: Facility[];
  onRefresh: () => void;
}

export default function JsonTab({ products, brands, facilities, onRefresh }: JsonTabProps) {
  return (
    <Tabs defaultValue="export" className="space-y-4">
      <TabsList className="grid w-full grid-cols-2">
        <TabsTrigger value="export">Export</TabsTrigger>
        <TabsTrigger value="import">Import</TabsTrigger>
      </TabsList>

      <TabsContent value="export">
        <JsonExporter products={products} brands={brands} facilities={facilities} onRefresh={onRefresh} />
      </TabsContent>

      <TabsContent value="import">
        <JsonImporterTab />
      </TabsContent>
    </Tabs>
  );
}
