"use client";

import { Product } from "@/types";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel";
import { ProductCard } from "@/components/ProductCard";
import { Badge } from "@/components/ui/badge"
import { Stethoscope } from "lucide-react";

interface ProductCarouselProps {
  title: string;
  products: Product[];
  onProductClick: (product: Product) => void;
  bgColor?: string;
  showAdsense?: boolean;
  categories?: Array<{ id: string; name: string }>
}

const ProductCarousel = ({
  title,
  products,
  onProductClick,
  bgColor,
  showAdsense,
  categories = []
}: ProductCarouselProps) => {

  if (products.length === 0) return null;

  return (
    <div className={`${bgColor ? `p-4 sm:p-6 rounded-lg ${bgColor}` : "py-4"}`}>
      <div className="mb-4">
        <h2 className="text-lg sm:text-xl font-bold mb-1 text-gray-900 flex items-center gap-2">
          <Stethoscope className="h-5 w-5 text-blue-600 flex-shrink-0" />
          {title}
        </h2>
        <p className="text-sm text-gray-600">
          {products.length} ürün
        </p>
      </div>

      <Carousel
        opts={{
          align: "start",
          loop: true,
          slidesToScroll: 1,
        }}
        className="w-full"
      >
        <CarouselContent className="-ml-2 sm:-ml-4">
          {products.map((product) => (
            <CarouselItem
              key={product.id}
              className="pl-2 sm:pl-4 basis-1/2 sm:basis-1/3 md:basis-1/4 lg:basis-1/5 xl:basis-1/6"
            >
              <div className="h-full">
                <ProductCard
                  product={product}
                  onClick={() => onProductClick(product)}
                  categories={categories}
                />
              </div>
            </CarouselItem>
          ))}
        </CarouselContent>

        {/* Navigation Buttons - Hidden on small screens */}
        <div className="hidden sm:block">
          <CarouselPrevious className="absolute -left-4 top-1/2 -translate-y-1/2 bg-white shadow-lg border-gray-200 hover:bg-gray-50" />
          <CarouselNext className="absolute -right-4 top-1/2 -translate-y-1/2 bg-white shadow-lg border-gray-200 hover:bg-gray-50" />
        </div>
      </Carousel>
    </div>
  );
};

export default ProductCarousel;
