// components/FeaturedProduct.tsx

"use client";

import { Product } from "@/types";
import Image from "next/image";
import { Card, CardContent } from "@/components/ui/card";
import Link from "next/link";

interface FeaturedProductProps {
  product: Product;
}

const FeaturedProduct = ({ product }: FeaturedProductProps) => {
  if (!product) return null;

  return (
    <Link href={`/product/${product.id}`} className="block w-full h-full group">
      <Card className="w-full h-full overflow-hidden transition-all duration-300 group-hover:shadow-xl">
        <CardContent className="p-0 h-full">
          <div className="grid md:grid-cols-2 h-full">
            <div className="relative h-48 md:h-full">
              <Image
                src={product.image || "/placeholder.svg"}
                alt={product.name}
                layout="fill"
                objectFit="contain"
                className="p-4 transition-transform duration-300 group-hover:scale-105"
              />
            </div>
            <div className="p-4 md:p-8 flex flex-col justify-center bg-gray-50/50">
              <h2 className="text-2xl md:text-3xl font-bold mb-2 md:mb-4 transition-colors duration-300 group-hover:text-blue-600">{product.name}</h2>
              <p className="text-lg text-gray-600 mb-2">{typeof product.brand === 'string' ? product.brand : product.brand.name}</p>
              <div className="mt-4">
                <p className="text-blue-600 font-semibold">Detayları Gör →</p>
              </div>
            </div>
          </div>
        </CardContent>
      </Card>
    </Link>
  );
};

export default FeaturedProduct;