"use client"

import { useState, useEffect } from "react"
import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"

export default function ConsentBanner() {
  const [isVisible, setIsVisible] = useState(false)

  useEffect(() => {
    const consent = localStorage.getItem("gdpr_consent")
    if (!consent) {
      setIsVisible(true)
    }
  }, [])

  const handleAccept = () => {
    localStorage.setItem("gdpr_consent", "accepted")
    setIsVisible(false)
    // Here you would typically load your analytics scripts, AdSense, etc.
    // For demonstration, we'll just log it.
    console.log("GDPR Consent Accepted. Loading ads/analytics.")
    // Example: loadAdSenseScript();
  }

  const handleDecline = () => {
    localStorage.setItem("gdpr_consent", "declined")
    setIsVisible(false)
    console.log("GDPR Consent Declined. Not loading ads/analytics.")
  }

  if (!isVisible) {
    return null
  }

  return (
    <div className="fixed bottom-4 left-0 right-0 z-[9999] p-4">
      <Card className="max-w-xl mx-auto">
        <CardContent className="p-4 flex flex-col md:flex-row items-center justify-between gap-4">
          <p className="text-sm text-gray-700 flex-1">
            Bu web sitesi, içeriği kişiselleştirmek, trafiği analiz etmek ve hedeflenmiş reklamlar sunmak için çerezleri ve benzer teknolojileri kullanır. Sitemizi kullanarak bu teknolojilerin kullanımını kabul etmiş olursunuz.
            <br />
            <a href="/privacy-policy" className="text-blue-600 hover:underline">Gizlilik Politikamızı</a> inceleyebilirsiniz.
          </p>
          <div className="flex gap-2 flex-shrink-0">
            <Button onClick={handleAccept} className="bg-blue-600 hover:bg-blue-700 text-white">
              Kabul Et
            </Button>
            <Button onClick={handleDecline} variant="outline">
              Reddet
            </Button>
          </div>
        </CardContent>
      </Card>
    </div>
  )
}
