// components/Adsense.tsx

"use client"

import { useEffect } from 'react';
import { usePathname } from 'next/navigation'; // EKLENDİ: Sayfa yolunu almak için.

interface AdsenseProps {
    // GÜNCELLENDİ: Reklam kimliklerini prop olarak alıyoruz.
    adClient: string;
    adSlot: string;
}

const Adsense = ({ adClient, adSlot }: AdsenseProps) => {
    // EKLENDİ: Mevcut sayfa yolunu (URL) alıyoruz.
    const pathname = usePathname();

    useEffect(() => {
        try {
            // Bu kod aynı kalıyor.
            (window.adsbygoogle = window.adsbygoogle || []).push({});
        } catch (err) {
            console.error(err);
        }
    // GÜNCELLENDİ: useEffect'in dependency array'ine pathname'i ekliyoruz.
    // Bu sayede, URL her değiştiğinde bu effect yeniden çalışır ve AdSense hatası çözülür.
    }, [pathname]);

    return (
        <div className="my-4 text-center bg-gray-50 p-2 rounded-lg">
            <ins
                // EKLENDİ: Her reklam biriminin React için benzersiz olduğunu belirtmek adına bir key ekliyoruz.
                key={pathname + adSlot} 
                className="adsbygoogle"
                style={{ display: 'block' }}
                data-ad-client={adClient}
                data-ad-slot={adSlot}
                data-ad-format="auto"
                data-full-width-responsive="true"
            ></ins>
        </div>
    );
};

export default Adsense;