"use client"

import type React from "react"

import { useState } from "react"
import { Send } from "lucide-react"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Input } from "@/components/ui/input"
import { Label } from "@/components/ui/label"
import { Textarea } from "@/components/ui/textarea"
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"
import Header from "@/components/Header"
import MobileBottomBar from "@/components/MobileBottomBar"
import Footer from "@/components/Footer"
import { db } from "@/lib/firebase"
import { addDoc, collection, serverTimestamp } from "firebase/firestore"
import { Dialog, DialogContent, DialogHeader, DialogTitle, DialogFooter } from "@/components/ui/dialog"

export default function UrunTalepPage() {
  const [formData, setFormData] = useState({
    productName: "",
    brand: "",
    category: "",
    buyLink: "",
    description: "",
  })

  const [successOpen, setSuccessOpen] = useState(false)

  const handleSubmit = async (e: React.FormEvent) => {
    e.preventDefault()
    try {
      await addDoc(collection(db, "productRequests"), {
        ...formData,
        status: "pending",
        createdAt: serverTimestamp(),
      })
      setSuccessOpen(true)
    } catch (err) {
      alert("Bir hata oluştu. Lütfen tekrar deneyin.")
    }
  }

  const handleChange = (field: string, value: string) => {
    setFormData((prev) => ({ ...prev, [field]: value }))
  }

  return (
    <div className="min-h-screen bg-gray-50 flex flex-col">
      <Header onSearch={() => {}} onCategoryChange={() => {}} showCategories={false} categories={[]} showSearchBox={false} />

      {/* Hero Section */}
      <div className="bg-gradient-to-r from-blue-600 to-blue-700 text-white py-16">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-4xl font-bold mb-4">Aradığın ürünü bulamadın mı?</h1>
          <p className="text-xl opacity-90">Ürün eklememizi talep et, en kısa sürede değerlendirip ekleyelim</p>
        </div>
      </div>

      <main className="flex-1 container mx-auto px-4 py-12">
        <div className="max-w-2xl mx-auto">
          <Card className="shadow-lg">
            <CardHeader>
              <CardTitle className="text-2xl text-blue-600">Ürün Talep Formu</CardTitle>
            </CardHeader>
            <CardContent>
              <form onSubmit={handleSubmit} className="space-y-6">
                <div className="space-y-2">
                  <Label htmlFor="productName">Ürün Adı *</Label>
                  <Input
                    id="productName"
                    placeholder="Örn: Vitamin D3 2000 IU"
                    value={formData.productName}
                    onChange={(e) => handleChange("productName", e.target.value)}
                    required
                  />
                </div>

                <div className="space-y-2">
                  <Label htmlFor="brand">Marka *</Label>
                  <Input
                    id="brand"
                    placeholder="Örn: Nature's Bounty"
                    value={formData.brand}
                    onChange={(e) => handleChange("brand", e.target.value)}
                    required
                  />
                </div>

                <div className="space-y-2">
                  <Label htmlFor="category">Kategori *</Label>
                  <Select onValueChange={(value) => handleChange("category", value)}>
                    <SelectTrigger>
                      <SelectValue placeholder="Kategori seçin" />
                    </SelectTrigger>
                    <SelectContent>
                      <SelectItem value="vitamin-mineral">Vitamin & Mineral</SelectItem>
                      <SelectItem value="sporcu-takviyeleri">Sporcu Takviyeleri</SelectItem>
                      <SelectItem value="cocuk-takviyeleri">Çocuk Takviyeleri</SelectItem>
                      <SelectItem value="meyve-cipsleri">Meyve Cipsleri</SelectItem>
                      <SelectItem value="diger">Diğer</SelectItem>
                    </SelectContent>
                  </Select>
                </div>

                <div className="space-y-2">
                  <Label htmlFor="buyLink">Satın Alma Linki</Label>
                  <Input
                    id="buyLink"
                    type="url"
                    placeholder="https://..."
                    value={formData.buyLink}
                    onChange={(e) => handleChange("buyLink", e.target.value)}
                  />
                  <p className="text-sm text-gray-600">
                    Ürünü nereden satın alabileceğimizi belirtirseniz daha hızlı değerlendiririz
                  </p>
                </div>

                <div className="space-y-2">
                  <Label htmlFor="description">Ek Açıklama</Label>
                  <Textarea
                    id="description"
                    placeholder="Ürün hakkında bilmek istediğiniz özel bir şey var mı?"
                    value={formData.description}
                    onChange={(e) => handleChange("description", e.target.value)}
                    rows={4}
                  />
                </div>

                <Button type="submit" className="w-full" size="lg">
                  <Send className="h-5 w-5 mr-2" />
                  Talep Gönder
                </Button>
              </form>

              <div className="mt-8 p-4 bg-blue-50 rounded-lg">
                <h3 className="font-semibold text-blue-800 mb-2">Bilgi</h3>
                <ul className="text-sm text-blue-700 space-y-1">
                  <li>• Talebiniz 24-48 saat içinde değerlendirilecektir</li>
                  <li>• Uygun bulunan ürünler 1 hafta içinde siteye eklenecektir</li>
                  <li>• Eklenen ürünler hakkında email ile bilgilendirileceksiniz</li>
                </ul>
              </div>
            </CardContent>
          </Card>
        </div>
      </main>

      <Footer />

      <MobileBottomBar
        onSearch={() => {}}
        onCategoryChange={() => {}}
        filters={{
          category: "*",
          subCategories: [],
          brands: [],
          contents: [],
          rating: { green: false, red: false },
          search: "",
          yerliMarka: false,
        }}
        onFiltersChange={() => {}}
        categories={[]}
      />

      <Dialog open={successOpen} onOpenChange={(open) => {
        setSuccessOpen(open)
        if (!open) {
          setFormData({
            productName: "",
            brand: "",
            category: "",
            buyLink: "",
            description: "",
          })
        }
      }}>
        <DialogContent className="max-w-xs text-center">
          <DialogHeader>
            <DialogTitle>Talebiniz başarıyla gönderildi!</DialogTitle>
          </DialogHeader>
          <div className="text-gray-600 mt-2 mb-4 text-sm">En kısa sürede değerlendirilecektir.</div>
          <DialogFooter>
            <Button onClick={() => setSuccessOpen(false)} className="w-full">Tamam</Button>
          </DialogFooter>
        </DialogContent>
      </Dialog>
    </div>
  )
}
