import React from 'react';

export default function PrivacyPolicyPage() {
  return (
    <div className="container mx-auto px-4 py-8">
      <h1 className="text-3xl font-bold mb-6">Gizlilik Politikası</h1>

      <section className="mb-8">
        <h2 className="text-2xl font-semibold mb-4">1. Giriş</h2>
        <p className="text-gray-700 leading-relaxed">
          Bu gizlilik politikası, web sitemizi ziyaret ettiğinizde kişisel verilerinizin nasıl toplandığını, kullanıldığını ve korunduğunu açıklamaktadır. Gizliliğiniz bizim için önemlidir ve verilerinizi sorumlu bir şekilde işlemeyi taahhüt ediyoruz.
        </p>
      </section>

      <section className="mb-8">
        <h2 className="text-2xl font-semibold mb-4">2. Topladığımız Bilgiler</h2>
        <p className="text-gray-700 leading-relaxed">
          Web sitemizi ziyaret ettiğinizde, aşağıdaki türde bilgileri toplayabiliriz:
        </p>
        <ul className="list-disc list-inside text-gray-700 ml-4">
          <li>Tarayıcı türü ve sürümü</li>
          <li>İşletim sistemi</li>
          <li>Referans URL'ler</li>
          <li>Ziyaret edilen sayfalar</li>
          <li>Ziyaretin tarihi ve saati</li>
          <li>IP adresi</li>
        </ul>
        <p className="text-gray-700 leading-relaxed mt-4">
          Formlar aracılığıyla bize sağladığınız kişisel bilgiler (ad, e-posta adresi vb.) de toplanabilir.
        </p>
      </section>

      <section className="mb-8">
        <h2 className="text-2xl font-semibold mb-4">3. Bilgilerin Kullanımı</h2>
        <p className="text-gray-700 leading-relaxed">
          Topladığımız bilgileri aşağıdaki amaçlarla kullanabiliriz:
        </p>
        <ul className="list-disc list-inside text-gray-700 ml-4">
          <li>Web sitesi deneyiminizi kişiselleştirmek</li>
          <li>Hizmetlerimizi iyileştirmek</li>
          <li>İsteklerinize yanıt vermek</li>
          <li>Pazarlama ve tanıtım faaliyetleri (onayınızla)</li>
        </ul>
      </section>

      <section className="mb-8">
        <h2 className="text-2xl font-semibold mb-4">4. Çerezler (Cookies)</h2>
        <p className="text-gray-700 leading-relaxed">
          Web sitemiz, deneyiminizi geliştirmek için çerezleri kullanır. Çerezler, tarayıcınızda depolanan küçük veri parçacıklarıdır. Çerezleri tarayıcı ayarlarınızdan kontrol edebilir veya silebilirsiniz.
        </p>
      </section>

      <section className="mb-8">
        <h2 className="text-2xl font-semibold mb-4">5. Üçüncü Taraf Hizmetleri</h2>
        <p className="text-gray-700 leading-relaxed">
          Web sitemiz, Google Analytics ve Google AdSense gibi üçüncü taraf hizmetlerini kullanabilir. Bu hizmetler, web sitesi kullanımını analiz etmek ve reklamları kişiselleştirmek için çerezleri kullanır. Bu hizmetlerin veri toplama ve kullanma uygulamaları hakkında daha fazla bilgi için ilgili üçüncü tarafın gizlilik politikalarını inceleyebilirsiniz.
        </p>
      </section>

      <section className="mb-8">
        <h2 className="text-2xl font-semibold mb-4">6. Veri Güvenliği</h2>
        <p className="text-gray-700 leading-relaxed">
          Kişisel verilerinizin güvenliğini sağlamak için uygun teknik ve organizasyonel önlemleri alıyoruz. Ancak, internet üzerinden hiçbir veri aktarımının %100 güvenli olduğu garanti edilemez.
        </p>
      </section>

      <section className="mb-8">
        <h2 className="text-2xl font-semibold mb-4">7. Haklarınız</h2>
        <p className="text-gray-700 leading-relaxed">
          GDPR kapsamında, kişisel verilerinizle ilgili belirli haklara sahipsiniz. Bunlar arasında verilerinize erişim, düzeltme, silme ve işlemeyi kısıtlama hakları bulunmaktadır. Bu haklarınızı kullanmak için bizimle iletişime geçebilirsiniz.
        </p>
      </section>

      <section>
        <h2 className="text-2xl font-semibold mb-4">8. İletişim</h2>
        <p className="text-gray-700 leading-relaxed">
          Gizlilik politikamız hakkında herhangi bir sorunuz varsa, lütfen bizimle iletişime geçmekten çekinmeyin.
        </p>
      </section>
    </div>
  );
}
