import type React from "react";
import type { Metadata } from "next";
import { Inter, Poppins } from "next/font/google";
import { Toaster } from "@/components/ui/sonner";
import "./globals.css";

const inter = Inter({ subsets: ["latin"] });
const poppins = Poppins({
  subsets: ["latin"],
  weight: ["300", "400", "500", "600", "700"],
});

export const metadata: Metadata = {
  title: "Vitamin & Takviye Dedektifi",
  description:
    "En kaliteli vitamin ve takviye ürünlerini keşfedin - Uzman değerlendirmeleri ile güvenilir rehberiniz",
  generator: "Vitamin Dedektifi",
  keywords:
    "vitamin, takviye, sağlık, besin takviyesi, vitamin analizi, ürün değerlendirmesi",
  authors: [{ name: "Vitamin Dedektifi" }],
  robots: "index, follow",
};

export const viewport = {
  width: "device-width",
  initialScale: 1,
  maximumScale: 1,
  userScalable: false,
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="tr" className="smooth-scroll">
      <head>
        <meta name="theme-color" content="#2563eb" />
        <meta name="apple-mobile-web-app-capable" content="yes" />
        <meta name="apple-mobile-web-app-status-bar-style" content="default" />
        <meta name="format-detection" content="telephone=no" />
      </head>
      <body className={`${poppins.className} antialiased touch-manipulation`}>
        {children}
        <Toaster richColors position="top-center" />
      </body>
    </html>
  );
}
