"use client"

import { MapPin, Phone, Mail } from "lucide-react"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import Header from "@/components/Header"
import MobileBottomBar from "@/components/MobileBottomBar"
import Footer from "@/components/Footer"

export default function IletisimPage() {
  return (
    <div className="min-h-screen bg-gray-50 flex flex-col">
      <Header onSearch={() => {}} onCategoryChange={() => {}} showCategories={false} categories={[]} showSearchBox={false} />

      {/* Hero Section */}
      <div className="bg-gradient-to-r from-blue-600 to-blue-700 text-white py-16">
        <div className="container mx-auto px-4 text-center">
          <h1 className="text-4xl font-bold mb-4">İletişim</h1>
          <p className="text-xl opacity-90">Bize aşağıdaki yollardan ulaşabilirsiniz</p>
        </div>
      </div>

      <main className="flex-1 container mx-auto px-4 py-12">
        <div className="max-w-4xl mx-auto">
          <Card className="shadow-lg">
            <CardHeader>
              <CardTitle className="text-2xl text-blue-600">İletişim Bilgileri</CardTitle>
            </CardHeader>
            <CardContent className="space-y-8">
              {/* Contact Info */}
              <div className="grid md:grid-cols-3 gap-6">
                <div className="flex items-start gap-3">
                  <MapPin className="h-6 w-6 text-blue-600 mt-1 flex-shrink-0" />
                  <div>
                    <h3 className="font-semibold mb-2">Adres</h3>
                    <p className="text-gray-600 text-sm">
                      Başak Mahallesi, 5. Etap, 2. Kısım, Abdülhamithan Cd No:5, 34306 Başakşehir
                    </p>
                  </div>
                </div>

                <div className="flex items-start gap-3">
                  <Phone className="h-6 w-6 text-blue-600 mt-1 flex-shrink-0" />
                  <div>
                    <h3 className="font-semibold mb-2">Telefon</h3>
                    <p className="text-gray-600">+90 212 123 45 67</p>
                  </div>
                </div>

                <div className="flex items-start gap-3">
                  <Mail className="h-6 w-6 text-blue-600 mt-1 flex-shrink-0" />
                  <div>
                    <h3 className="font-semibold mb-2">Email</h3>
                    <p className="text-gray-600">destek@vitamintakviye.com</p>
                  </div>
                </div>
              </div>

              {/* Map Section */}
              <div>
                <h3 className="font-semibold text-lg mb-4">Haritada Konumumuz</h3>
                <div className="border-2 border-gray-200 rounded-lg overflow-hidden">
                  <iframe
                    src="https://maps.google.com/maps?q=41.0953445,28.8031616&z=17&output=embed"
                    width="100%"
                    height="300"
                    style={{ border: 0 }}
                    allowFullScreen
                    loading="lazy"
                    className="w-full"
                  />
                </div>
              </div>

              {/* Working Hours */}
              <div className="bg-blue-50 rounded-lg p-6">
                <h3 className="font-semibold text-lg mb-4 text-blue-800">Çalışma Saatleri</h3>
                <div className="grid md:grid-cols-2 gap-4 text-sm">
                  <div>
                    <p className="font-medium">Pazartesi - Cuma</p>
                    <p className="text-gray-600">09:00 - 18:00</p>
                  </div>
                  <div>
                    <p className="font-medium">Cumartesi</p>
                    <p className="text-gray-600">09:00 - 16:00</p>
                  </div>
                  <div>
                    <p className="font-medium">Pazar</p>
                    <p className="text-gray-600">Kapalı</p>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </main>

      <Footer />

      <MobileBottomBar
        onSearch={() => {}}
        onCategoryChange={() => {}}
        filters={{
          category: "*",
          subCategories: [],
          brands: [],
          contents: [],
          rating: { green: false, red: false },
          search: "",
          yerliMarka: false,
        }}
        onFiltersChange={() => {}}
        categories={[]}
      />
    </div>
  )
}
