import type { NextApiRequest, NextApiResponse } from 'next';
import { doc, getDoc } from 'firebase/firestore';
import { db } from '@/lib/firebase';

export default async function handler(req: NextApiRequest, res: NextApiResponse) {
  if (req.method === 'POST') {
    const { productId, productName } = req.body;

    if (!productId || !productName) {
      return res.status(400).json({ error: 'Product ID and Product Name are required.' });
    }

    try {
      // Optionally, fetch product details from Firestore if needed
      // const productRef = doc(db, 'products', productId);
      // const productSnap = await getDoc(productRef);
      // if (!productSnap.exists()) {
      //   return res.status(404).json({ error: 'Product not found in Firestore.' });
      // }
      // const productData = productSnap.data();

      // Call the Python AI service for auto-processing
      const aiResponse = await fetch('http://localhost:4002/auto_process_product', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({ productName }),
      });

      if (!aiResponse.ok) {
        const errorData = await aiResponse.json();
        throw new Error(errorData.error || 'AI otomatik işleme hizmetinden hata alındı.');
      }

      const aiResult = await aiResponse.json();

      // Update product in Firestore with the processed data
      const productRef = doc(db, 'products', productId);
      await updateDoc(productRef, {
        aiScore: aiResult.ai_score || null,
        content: aiResult.content || null,
        ingredients: aiResult.ingredients || null,
        reviews: aiResult.reviews || null,
        image: aiResult.image_url || null,
        buyLink: aiResult.purchase_link || null,
        brand: aiResult.brand || null,
        category: aiResult.category || null,
        subCategory: aiResult.sub_category || null,
        usage: aiResult.usage_instructions || null,
        warnings_and_side_effects: aiResult.warnings_and_side_effects || null,
        icerik: aiResult.ingredients || null, // icerik alanı için ingredients kullan
        icerik_bilgisi: aiResult.ingredients_info || null, // icerik_bilgisi alanı için ingredients_info kullan
      });

      return res.status(200).json({ message: `'${productName}' ürünü otomatik işleme başarıyla tamamlandı.`, aiResult });
    } catch (error: any) {
      console.error('Otomatik ürün işleme hatası:', error);
      return res.status(500).json({ error: (error instanceof Error) ? error.message : String(error || 'Bilinmeyen bir hata oluştu.') });
    }
  } else {
    res.setHeader('Allow', ['POST']);
    res.status(405).end(`Method ${req.method} Not Allowed`);
  }
}
